; corz gui window animation effects example
;
#include <GuiConstants.au3>
#include <corz_gui_fx.au3>
AutoItSetOption("GUIOnEventMode", 1)
HotKeySet("{ESC}","DoQuit")

$show = true
$gui = GUICreate("My Animating GUI", 200, 80)
GUISetOnEvent($GUI_EVENT_CLOSE, "DoQuit", $gui)
$label = GUICtrlCreateLabel("up/down arrow keys also work fine", 10, 36, 175)

$combo = GUICtrlCreateCombo("", 10, 10, 115, 20)
GUICtrlSetData(-1, "Slide Left|Slide Top|Slide Right|Slide Bottom|Slide Top Left|Slide Top Right|Slide Bottom Right|Slide Bottom Left|Explode/Implode|Fade|Disable")
GUICtrlSetOnEvent(-1, "ComboSetWinAnim")

$button = GUICtrlCreateButton("do it!", 130, 10, 50, 20)
GUICtrlSetOnEvent(-1, "ComboSetWinAnim")

; retrieve ini settings, and use them to initialize the window..
$my_fx = corz_GUIAnimateOpen($gui, "", "test.ini", "fx demo")
GUICtrlSetData($combo, EnvGet('gui_fx'))

do ; idle loop..
	Sleep(333)
until not $show

corz_GUIAnimateClose($gui, $my_fx)
; fin


func ComboSetWinAnim()
	$my_fx = corz_GUIAnimateClose($gui, GUICtrlRead($combo), "test.ini", "fx demo")
	Sleep(333)
	corz_GUIAnimateOpen($gui, $my_fx)
endfunc

; bye!
func DoQuit()
	$show = false
endfunc
